vs.1.0
; shader declaration
;
; vertex stream is 0
; v0 is a float3 (position)
; v1 is a packed byte DWORD (color)
;
; .stream	0
; .loadv	v0, f3
; .loadv	v1, pb
; .end

; c[0..3] = WVP matrix

;  c5 = Lower Left
;  c6 = Upper Right

; c[7..10] = LTM
; transform vertex position


m4x4	r0, v0, c[0]		; r0 = vertex_pos * WVP
mov		oPos, r0			; r0 = modified position
m4x4	r3, v0, c[7]		; r0 = vertex_pos * WVP

mov		r11, c6				; r11 = c6

add		r4, r11, -c5		; r4 = c6 - c5
add		r5, c6, -r3			; r5 = c6 - worldPos

rcp		r6, r4.x			; r6 = 1/r4.x
rcp		r7, r4.z			; r7 = 1/r4.z

mul		r8.x, r5.x, r6.x	; r8.x = r5.x/r4.x
mul		r8.z, r5.z, r7.z	; r8.z = r5.z/r4.z

max		r8.x, r8.x, c11.w	; lock texture coords to [0..1]
min		r8.x, r8.x, c11.y	;
max		r8.z, r8.z, c11.w	;
min		r8.z, r8.z, c11.y	;

; copy colour
mov oT0.xy, v9				; v9 = tex0 coords
mov oT1.xy, r8.xz			; set tex1 coords
mov oD0, v3;				; copy through diffuse color
